//Determine the operating point of Fixed Bias ckt given transistor gain,Vbe
//Windows 10
//Scilab 6.0.0

clc;
clear;
close;

tgain=100           //beta (or) transistor gain //unitless
Vcc=15               //in volts
Vbe=0.7             //base emitter voltage in volts
Rb=1*10e6            //resistance in ohms
Rc=4*10e3            //resistance in ohms
Ic=Vcc/Rc
Icq=tgain*((Vcc-Vbe)/Rb)    //collector current in milli Ampere
Vceq=Vcc-(Icq*Rc)    //collector emitter voltage in volts
Vce=Vcc-(Ic*Rc)                 //load line equation for fixed-bias ckt
//Substituting Ic=0,Vce=Vcc=15v 
Ic1x=0
Vcex=Vcc-(Ic1x*Rc)
//coordinates of load line on x-axis are(0 mA,15V)
//Substituting Vce=0,Ic=Vcc/Rc=3.75mA 
Vcey=0
Icy=Vcc/Rc
//coordinates of load line on y-axis are(3.75 mA,0V)
Icq=Icq*10e3
Vce=Vce*10e3
Icy=Icy*10e3
mprintf('Collector Current Icq=%.2fmA',Icq)
mprintf('\nCollector-Emitter Voltage Vceq=%.2fV',Vceq)
mprintf('\nX-Axis Coordinates(%dmA,%dV)',Ic1x,Vcex)
mprintf('\nY-Axis Coordinates(%.2fmA,%dV)',Icy,Vcey)
mprintf('\nOperating Point is Icq=%.2fmA and Vceq=%.2fV',Icq,Vceq)

//plotting the load line
x=[Ic1x,Vcex]
y=[Icy,Vcey]
clf()
plot(x,y)
xtitle('Load Line');
xlabel('Vce(V)');ylabel('Ic(mA)');

